/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Plan;
import cds.aladin.PlanField;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.Tok;
import cds.aladin.ViewSimple;
import cds.aladin.prop.Prop;
import cds.aladin.prop.PropAction;
import cds.tools.FastMath;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class Tag
extends Position {
    private static final int MINDIST = 3;
    private static final int MAXDIST = 300;
    private static final int MINFONT = 7;
    private static final int MAXFONT = 60;
    public static final int RETICLE = 0;
    public static final int BIGRETICLE = 1;
    public static final int SMALLCIRCLE = 2;
    public static final int CIRCLE = 3;
    public static final int BIGCIRCLE = 4;
    public static final int ARROW = 5;
    public static final int BIGARROW = 6;
    public static final int NOPOLE = 7;
    private static final String[] TAGS = new String[]{"reticle", "bigreticle", "smallcircle", "circle", "bigcircle", "arrow", "bigarrow", "nopole"};
    private static final int[] TAGSIZE = new int[]{5, 8, 3, 5, 8, 2, 2, 0};
    private final int NOTHING = 0;
    private final int LABEL = 1;
    private final int TAG = 2;
    private final int POIGNEE = 3;
    private final int CORNER = 4;
    private int L = 5;
    private int tag = 0;
    private double angle = 0.7853981633974483;
    private double dist = 0.0;
    private int accroche = 10;
    private Color couleur = null;
    private float fond = 0.0f;
    private int bord = 0;
    private Font F = Aladin.BOLD;
    private boolean editing;
    private int on = 0;
    private double distAngulaireOrig = 0.0;
    private Rectangle rect1 = null;
    private Rectangle rect2 = null;
    private static final String C = "|";
    private static final int T = 4;

    private Tag() {
    }

    protected Tag(Plan plan, ViewSimple v, double x, double y) {
        super(plan, v, x, y, 0.0, 0.0, 5, "");
    }

    protected Tag(Plan plan, ViewSimple v, double x, double y, String id) {
        super(plan, v, x, y, 0.0, 0.0, 5, id);
        this.setText(id);
        this.setWH();
    }

    protected Tag(Plan plan, Coord c, String id) {
        super(plan, null, 0.0, 0.0, c.al, c.del, 2, id);
        this.setText(id);
        this.setWH();
    }

    protected Tag(Plan plan) {
        super(plan);
    }

    protected Tag(PlanField plan, String content, double ra, double dec) {
        this(plan);
        this.setText(content);
        this.setXYTan(Util.tand(ra), Util.tand(dec));
        this.distAngulaireOrig = 1000.0;
        this.accroche = 0;
        this.dist = 1.0;
    }

    protected Tag copy() {
        Tag t = new Tag();
        t.L = this.L;
        t.tag = this.tag;
        t.angle = this.angle;
        t.dist = this.dist;
        t.accroche = this.accroche;
        t.couleur = this.couleur;
        t.fond = this.fond;
        t.F = this.F;
        t.editing = this.editing;
        t.on = this.on;
        t.distAngulaireOrig = this.distAngulaireOrig;
        return t;
    }

    public Vector getProp() {
        Vector<Prop> propList = super.getProp();
        Prop.remove(propList, "id");
        final JTextField textAngle = new JTextField(10);
        final PropAction updateAngle = new PropAction(){

            @Override
            public int action() {
                textAngle.setText("" + (360 - (int)Math.round(Math.toDegrees(Tag.this.angle))));
                return 1;
            }
        };
        PropAction changeAngle = new PropAction(){

            @Override
            public int action() {
                try {
                    textAngle.setForeground(Color.black);
                    int nangle = Integer.parseInt(textAngle.getText());
                    if (nangle == 360 - (int)Math.round(Math.toDegrees(Tag.this.angle))) {
                        return -1;
                    }
                    Tag.this.angle = Math.toRadians(360 - nangle);
                    return 1;
                }
                catch (Exception e) {
                    updateAngle.action();
                    textAngle.setForeground(Color.red);
                    return 0;
                }
            }
        };
        propList.add(Prop.propFactory("angle", "Angle", "Pole orientation (in degrees - trigonometric orientation)", textAngle, updateAngle, changeAngle));
        final JTextField textDist = new JTextField(10);
        final PropAction updateDist = new PropAction(){

            @Override
            public int action() {
                textDist.setText("" + (int)Tag.this.dist);
                return 1;
            }
        };
        PropAction changeDist = new PropAction(){

            @Override
            public int action() {
                try {
                    textDist.setForeground(Color.black);
                    int ndist = Integer.parseInt(textDist.getText());
                    if (ndist == (int)Tag.this.dist) {
                        return -1;
                    }
                    Tag.this.dist = ndist;
                    return 1;
                }
                catch (Exception e) {
                    updateDist.action();
                    textDist.setForeground(Color.red);
                    return 0;
                }
            }
        };
        propList.add(Prop.propFactory("dist", "Pole size", "Pole size (in pixels)", textDist, updateDist, changeDist));
        final JComboBox<String> pole = new JComboBox<String>(TAGS);
        PropAction updatePole = new PropAction(){

            @Override
            public int action() {
                pole.setSelectedIndex(Tag.this.tag);
                return 1;
            }
        };
        final PropAction changePole = new PropAction(){

            @Override
            public int action() {
                int npole = pole.getSelectedIndex();
                if (Tag.this.tag == npole) {
                    return -1;
                }
                Tag.this.tag = npole;
                return 1;
            }
        };
        pole.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                changePole.action();
                Tag.this.plan.aladin.view.repaintAll();
            }
        });
        propList.add(Prop.propFactory("tag", "Arrow head", "Alternative arrow head", pole, updatePole, changePole));
        final JTextField textSize = new JTextField(10);
        final PropAction updateSize = new PropAction(){

            @Override
            public int action() {
                textSize.setText(Tag.this.F.getSize() + "");
                return 1;
            }
        };
        PropAction changeSize = new PropAction(){

            @Override
            public int action() {
                try {
                    textSize.setForeground(Color.black);
                    float nsize = Float.parseFloat(textSize.getText());
                    if (nsize == (float)Tag.this.F.getSize()) {
                        return -1;
                    }
                    Tag.this.F = Tag.this.F.deriveFont(nsize);
                    return 1;
                }
                catch (Exception e) {
                    updateSize.action();
                    textSize.setForeground(Color.red);
                    return 0;
                }
            }
        };
        propList.add(Prop.propFactory("fontsize", "Font size", null, textSize, updateSize, changeSize));
        final Couleur col = new Couleur(this.couleur, true);
        final PropAction changeCouleur = new PropAction(){

            @Override
            public int action() {
                Color c = col.getCouleur();
                if (c == Tag.this.couleur) {
                    return -1;
                }
                Tag.this.couleur = c;
                return 1;
            }
        };
        col.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                changeCouleur.action();
                Tag.this.plan.aladin.view.repaintAll();
            }
        });
        propList.add(Prop.propFactory("color", "Color", "Alternative color", col, null, changeCouleur));
        final JTextArea textId = new JTextArea(3, 25);
        JScrollPane paneId = new JScrollPane(textId);
        PropAction updateId = new PropAction(){

            @Override
            public int action() {
                textId.setText(Tag.this.id);
                return 1;
            }
        };
        PropAction changeId = new PropAction(){

            @Override
            public int action() {
                String s = textId.getText();
                if (s.equals(Tag.this.id)) {
                    return -1;
                }
                Tag.this.id = textId.getText();
                return 1;
            }
        };
        propList.add(Prop.propFactory("id", "Label", "Tag label", paneId, updateId, changeId));
        final JCheckBox bordCheck = new JCheckBox("with border");
        PropAction updateBord = new PropAction(){

            @Override
            public int action() {
                bordCheck.setSelected(Tag.this.bord == 1);
                return 1;
            }
        };
        final PropAction changeBord = new PropAction(){

            @Override
            public int action() {
                if (bordCheck.isSelected() == (Tag.this.bord == 1)) {
                    return -1;
                }
                Tag.this.bord = bordCheck.isSelected() ? 1 : 0;
                return 1;
            }
        };
        bordCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                changeBord.action();
                Tag.this.plan.aladin.view.repaintAll();
            }
        });
        propList.add(Prop.propFactory("border", "Label border", null, bordCheck, updateBord, changeBord));
        final JSlider transSlider = new JSlider();
        PropAction updateTrans = new PropAction(){

            @Override
            public int action() {
                transSlider.setValue((int)(Tag.this.fond * 100.0f));
                return 1;
            }
        };
        final PropAction changeTrans = new PropAction(){

            @Override
            public int action() {
                if (transSlider.getValue() == (int)(Tag.this.fond * 100.0f)) {
                    return -1;
                }
                Tag.this.fond = (float)((double)transSlider.getValue() / 100.0);
                return 1;
            }
        };
        transSlider.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                changeTrans.action();
                Tag.this.plan.aladin.view.repaintAll();
            }
        });
        propList.add(Prop.propFactory("background", "Label background", null, transSlider, updateTrans, changeTrans));
        return propList;
    }

    @Override
    public String getCommand() {
        return "draw tag(" + this.getLocalisation() + "," + Tok.quote(this.id) + "," + Math.round(this.dist) + "," + Math.round(270.0 - Math.toDegrees(this.angle)) + "," + TAGS[this.tag] + "," + this.F.getSize() + ")";
    }

    @Override
    protected String getSpecificAJInfo() {
        return (!this.hasLabel() ? "" : this.id.replace("\n", "\\n")) + C + TAGS[this.tag] + C + this.L + C + this.angle + C + this.dist + C + this.fond + C + this.bord + C + this.getFont().getSize() + C + this.distAngulaireOrig;
    }

    @Override
    protected void setSpecificAJInfo(String s) {
        block3: {
            try {
                int offset = s.indexOf(C);
                String s1 = s.substring(0, offset);
                this.setText(s1);
                Tok tok = new Tok(s.substring(offset + C.length()), C);
                this.tag = Util.indexInArrayOf(tok.nextToken(), TAGS, true);
                if (this.tag == -1) {
                    this.tag = 0;
                }
                this.L = Integer.parseInt(tok.nextToken());
                this.angle = Double.parseDouble(tok.nextToken());
                this.dist = Double.parseDouble(tok.nextToken());
                this.fond = Float.parseFloat(tok.nextToken());
                this.bord = Integer.parseInt(tok.nextToken());
                float size = Float.parseFloat(tok.nextToken());
                this.setFont(Aladin.BOLD.deriveFont(size));
                this.distAngulaireOrig = Double.parseDouble(tok.nextToken());
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block3;
                e.printStackTrace();
            }
        }
        this.setWH();
    }

    @Override
    public String getObjType() {
        return "Tag";
    }

    protected void setDist(int dist) {
        this.dist = dist;
        this.setWH();
    }

    protected void setAngle(int angle) {
        this.angle = Math.toRadians(270 - angle);
        this.setWH();
    }

    protected void setPole(String pole) {
        this.tag = Util.indexInArrayOf(pole, TAGS, true);
        if (this.tag == -1) {
            this.tag = 0;
        }
        this.L = TAGSIZE[this.tag];
        this.setWH();
    }

    protected void setFontSize(int size) {
        this.setFont(this.getFont().deriveFont((float)size));
        this.setWH();
    }

    @Override
    protected void setText(String id) {
        this.id = id == null || id.length() == 0 ? "" : id.replace("\\n", "\n");
        this.setWH();
    }

    @Override
    public void setInfo(String info) {
        this.setText(info);
    }

    protected void setEditing(boolean flag) {
        this.editing = flag;
        this.setSelected(flag);
        if (this.editing) {
            this.plan.aladin.view.startTimer(500);
        }
    }

    protected void setDistAngulaireOrig(ViewSimple v) {
        Projection proj = v.getProj();
        if (!Projection.isOk(proj)) {
            this.distAngulaireOrig = 0.0;
            return;
        }
        Coord c = new Coord();
        c.y = this.dist;
        c.x = 0.0;
        proj.getCoord(c);
        this.distAngulaireOrig = Math.abs(c.del * v.zoom);
    }

    private boolean isTooSmallForLabel(ViewSimple v) {
        if (this.distAngulaireOrig == 0.0 || v.getProj() == null) {
            return false;
        }
        Coord c = new Coord();
        c.y = this.dist;
        c.x = 0.0;
        v.getProj().getCoord(c);
        double nDistAngulaire = Math.abs(c.del * v.zoom);
        return nDistAngulaire < this.distAngulaireOrig / 4.0;
    }

    protected boolean isEditing() {
        return this.editing;
    }

    void setWH() {
        this.rect2 = null;
        this.rect1 = new Rectangle(-this.L, -this.L, 2 * this.L, 2 * this.L);
        if (this.hasLabel()) {
            Point p = this.getXYLabel();
            Dimension d = this.getDimLabel();
            this.rect2 = new Rectangle(p.x - d.width / 2, p.y - d.height / 2, d.width, d.height);
            this.rect2.add(this.getXYPoignee());
        } else if (this.isArrow()) {
            this.rect1.add(this.getXYPoignee());
        }
    }

    private boolean isArrow() {
        return this.tag == 5 || this.tag == 6;
    }

    protected boolean isReticle() {
        return this.tag == 1 || this.tag == 0;
    }

    protected boolean hasLabel() {
        return this.id != null && this.id.trim().length() > 0;
    }

    @Override
    protected boolean inside(ViewSimple v, double x, double y) {
        return this.rect1.contains(x = (x - this.xv[v.n]) * v.zoom, y = (y - this.yv[v.n]) * v.zoom) || !this.isTooSmallForLabel(v) && this.rect2 != null && this.rect2.contains(x, y);
    }

    protected boolean onPoignee(ViewSimple v, double x, double y) {
        x = (x - this.xv[v.n]) * v.zoom;
        y = (y - this.yv[v.n]) * v.zoom;
        Point p = this.getXYPoignee();
        return Math.abs((double)p.x - x) < 4.0 && Math.abs((double)p.y - y) < 4.0;
    }

    protected boolean onLabel(ViewSimple v, double x, double y) {
        if (this.isTooSmallForLabel(v) || this.rect2 == null) {
            return false;
        }
        x = (x - this.xv[v.n]) * v.zoom;
        y = (y - this.yv[v.n]) * v.zoom;
        return this.rect2.contains(x, y);
    }

    private Rectangle larger(Rectangle r) {
        return new Rectangle(r.x - 4, r.y - 4, r.width + 8, r.height + 8);
    }

    protected boolean onTag(ViewSimple v, double x, double y) {
        x = (x - this.xv[v.n]) * v.zoom;
        y = (y - this.yv[v.n]) * v.zoom;
        return this.larger(this.rect1).contains(x, y);
    }

    protected boolean onCorner(ViewSimple v, double x, double y) {
        x = (x - this.xv[v.n]) * v.zoom;
        y = (y - this.yv[v.n]) * v.zoom;
        Point p = this.getXYCorner();
        return Math.abs((double)p.x - x) < 4.0 && Math.abs((double)p.y - y) < 4.0;
    }

    protected boolean onViaWheel(ViewSimple v, double x, double y) {
        this.on = this.onLabel(v, x, y) ? 1 : (this.onTag(v, x, y) ? 2 : 0);
        return this.on != 0;
    }

    protected void resetOn() {
        this.on = 0;
    }

    protected void modifyViaWheel(int sens) {
        if (this.on == 2) {
            this.modifyTag(sens);
        } else if (this.on == 1) {
            this.modifyFond(sens);
        }
    }

    protected boolean onViaMouse(ViewSimple v, double x, double y) {
        if (!this.hasLabel() && !this.isArrow()) {
            return false;
        }
        this.on = this.onPoignee(v, x, y) ? 3 : (this.onCorner(v, x, y) ? 4 : 0);
        return this.on != 0;
    }

    protected boolean modifyViaMouse(ViewSimple v, PointD p, PointD fixe) {
        if (this.on == 3) {
            return this.modifyPoignee(v, p.x, p.y);
        }
        if (this.on == 4) {
            double dx = p.x - fixe.x;
            fixe.x = p.x;
            return this.modifyCorner(v, dx);
        }
        return false;
    }

    protected boolean modifyPoignee(ViewSimple v, double x, double y) {
        double nangle;
        double ndist = Math.round(Math.sqrt((x = (x - this.xv[v.n]) * v.zoom) * x + (y = (y - this.yv[v.n]) * v.zoom) * y));
        if (ndist < 3.0) {
            ndist = 3.0;
        }
        double d = nangle = ndist == 3.0 ? this.angle : Math.atan2(y, x);
        if (nangle < 0.0) {
            nangle += Math.PI * 2;
        } else if (ndist > 300.0) {
            ndist = 300.0;
        }
        if ((double)Math.round(Math.toDegrees(nangle)) == Math.toDegrees(this.angle) && this.dist == ndist) {
            return false;
        }
        if (this.dist == 0.0 && this.tag == 0) {
            this.tag = 5;
        }
        this.angle = nangle;
        this.dist = ndist;
        if (this.tag == 7) {
            this.tag = 0;
        }
        this.setWH();
        return true;
    }

    protected boolean modifyCorner(ViewSimple v, double dx) {
        float nSize;
        float oSize = this.getFont().getSize();
        float cran = (float)(dx * v.zoom) / 3.0f;
        if (cran == 0.0f) {
            return false;
        }
        if (this.angle > 1.5707963267948966 && this.angle < 4.71238898038469) {
            cran = -cran;
        }
        if ((nSize = oSize + cran) < 7.0f) {
            nSize = 7.0f;
        } else if (nSize > 60.0f) {
            nSize = 60.0f;
        }
        this.setFont(this.getFont().deriveFont(nSize));
        this.setWH();
        return true;
    }

    protected void modifyTag(int sens) {
        this.tag += sens;
        if (this.tag < 0) {
            this.tag = TAGS.length - 2;
        } else if (this.tag >= TAGS.length - 1) {
            this.tag = 0;
        }
        this.adjustTagSize();
    }

    private void adjustTagSize() {
        this.L = TAGSIZE[this.tag];
    }

    protected void modifyFond(int sens) {
        this.fond += (float)sens * 0.2f;
        if (this.fond > 1.0f) {
            this.fond = 0.0f;
            this.bord = this.bord == 0 ? 1 : 0;
        } else if (this.fond < 0.0f) {
            this.fond = 1.0f;
            this.bord = this.bord == 0 ? 1 : 0;
        }
    }

    @Override
    protected void drawSelect(Graphics g, ViewSimple v) {
        if (!this.hasLabel() && !this.isArrow()) {
            super.drawSelect(g, v);
            return;
        }
        Point p = this.getViewCoord(v, 50, 50);
        Point poignee = this.getXYPoignee();
        int x = p.x + poignee.x;
        int y = p.y + poignee.y;
        g.setColor(this.on == 3 ? Color.orange : Color.green);
        Util.fillCircle5(g, x, y);
        g.setColor(Color.black);
        Util.drawCircle5(g, x, y);
        if (this.hasLabel()) {
            Point corner = this.getXYCorner();
            x = p.x + corner.x;
            y = p.y + corner.y;
            g.setColor(this.on == 4 ? Color.orange : Color.green);
            Util.fillCircle5(g, x, y);
            g.setColor(Color.black);
            Util.drawCircle5(g, x, y);
        }
    }

    @Override
    protected Rectangle extendClip(ViewSimple v, Rectangle clip) {
        Point p;
        if (!this.isVisible()) {
            return clip;
        }
        if (this.rect1 == null) {
            this.setWH();
        }
        if ((p = this.getViewCoord(v, 50, 50)) == null) {
            return clip;
        }
        int sel = 0;
        if (this.isSelected()) {
            sel = 4;
        }
        Point p1 = new Point(p.x + this.rect1.x - sel, p.y + this.rect1.y - sel);
        Point p2 = new Point(p.x + this.rect1.x + this.rect1.width + sel, p.y + this.rect1.y + this.rect1.height + sel);
        if (clip == null) {
            clip = new Rectangle(p1.x, p1.y, p2.x - p1.x + 1, p2.y - p1.y + 1);
        } else {
            clip.add(p1);
            clip.add(p2);
        }
        if (this.hasLabel() && this.rect2 != null) {
            p1 = new Point(p.x + this.rect2.x - sel, p.y + this.rect2.y - sel);
            p2 = new Point(p.x + this.rect2.x + this.rect2.width + sel, p.y + this.rect2.y + this.rect2.height + sel);
            clip.add(p1);
            clip.add(p2);
        }
        return clip;
    }

    @Override
    public Color getColor() {
        if (!this.isVisible()) {
            return null;
        }
        if (this.couleur != null) {
            return this.couleur;
        }
        if (this.plan != null && this.plan.type == 10) {
            this.couleur = ((PlanField)this.plan).getColor(this);
            if (this.couleur == null) {
                return this.plan.c;
            }
            return this.couleur;
        }
        if (this.plan != null) {
            return this.plan.c;
        }
        return Color.black;
    }

    private Point getXYAncrage() {
        if (this.isReticle()) {
            int x = 0;
            int y = 0;
            if (this.angle <= 0.7853981633974483 || this.angle >= 5.497787143782138) {
                x = this.L;
            } else if (this.angle >= 2.356194490192345 && this.angle <= 3.9269908169872414) {
                x = -this.L;
            }
            if (this.angle > 0.7853981633974483 && this.angle < 2.356194490192345) {
                y = this.L;
            } else if (this.angle > 3.9269908169872414 && this.angle < 5.497787143782138) {
                y = -this.L;
            }
            return new Point(x, y);
        }
        return new Point((int)Math.round((double)this.L * Math.cos(this.angle)), (int)Math.round((double)this.L * FastMath.sin(this.angle)));
    }

    private Point getXYPoignee() {
        return new Point((int)Math.round(this.dist * Math.cos(this.angle)), (int)Math.round(this.dist * FastMath.sin(this.angle)));
    }

    protected Font getFont() {
        double z;
        double d = z = this.plan != null ? (double)this.plan.getScalingFactor() : 1.0;
        if (z == 1.0) {
            return this.F;
        }
        float size = this.F.getSize();
        size = (float)((double)size * z);
        return this.F.deriveFont(size);
    }

    private void setFont(Font f) {
        this.F = f;
    }

    @Override
    public void setColor(Color c) {
        this.couleur = c;
    }

    private Dimension getDimLabel() {
        FontMetrics m = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        int h = 0;
        int w = 0;
        if (!this.hasLabel()) {
            return new Dimension(w, h);
        }
        StringTokenizer st = new StringTokenizer(this.id, "\n");
        while (st.hasMoreTokens()) {
            h += m.getHeight();
            int d = m.stringWidth(st.nextToken());
            if (d <= w) continue;
            w = d;
        }
        if (this.id.charAt(this.id.length() - 1) == '\n') {
            h += m.getHeight();
        }
        return new Dimension(w, h);
    }

    private Point getXYLabel() {
        Point p = this.getXYPoignee();
        int dx = (this.tag == 7 ? 0 : this.accroche) + this.getDimLabel().width / 2;
        p.x = p.x + (this.angle > 1.5707963267948966 && this.angle < 4.71238898038469 ? -dx : dx);
        return p;
    }

    private Point getXYCorner() {
        Point p = this.getXYLabel();
        Dimension d = this.getDimLabel();
        int M = 3;
        p.x = this.angle > 1.5707963267948966 && this.angle < 4.71238898038469 ? (p.x -= d.width / 2 - M) : (p.x += d.width / 2 - M);
        p.y = this.angle > Math.PI && this.angle < Math.PI * 2 ? (p.y -= d.height / 2 - M) : (p.y += d.height / 2 - M);
        return p;
    }

    private Point getXYLastChar() {
        Dimension dim = this.getDimLabel();
        Point p = this.getXYLabel();
        FontMetrics m = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        boolean aDroite = this.angle > 1.5707963267948966 && this.angle < 4.71238898038469;
        int y1 = p.y - dim.height / 2 + m.getAscent();
        Point p1 = new Point(p.x, y1 - 7);
        if (!this.hasLabel()) {
            return p1;
        }
        StringTokenizer st = new StringTokenizer(this.id, "\n");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            p1.x = p.x + (aDroite ? dim.width / 2 : -dim.width / 2 + m.stringWidth(s));
            p1.y = y1;
            y1 += m.getHeight();
        }
        if (this.id.charAt(this.id.length() - 1) == '\n') {
            p1.y += m.getHeight();
            p1.x = p.x + (aDroite ? dim.width / 2 : -dim.width / 2);
        }
        return p1;
    }

    protected void drawLabel(Graphics g, int x, int y) {
        Dimension dim = this.getDimLabel();
        Point p = this.getXYLabel();
        if (this.fond != 0.0f) {
            Util.drawArea(this.plan.aladin, g, p.x - (dim.width + 4) / 2 + x, p.y - (dim.height + 4) / 2 + y, dim.width + 4, dim.height + 4, Color.white, this.fond * this.plan.getOpacityLevel(), false);
        }
        if (this.bord == 1) {
            g.drawRect(p.x - (dim.width + 4) / 2 + x, p.y - (dim.height + 4) / 2 + y, dim.width + 4, dim.height + 4);
        }
        FontMetrics m = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        boolean aDroite = this.angle > 1.5707963267948966 && this.angle < 4.71238898038469;
        boolean centre = this.accroche == 0 && this.dist == 1.0;
        int y1 = p.y - dim.height / 2 + m.getAscent();
        StringTokenizer st = new StringTokenizer(this.id, "\n");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            int x1 = p.x + (centre ? -m.stringWidth(s) : (aDroite ? dim.width / 2 - m.stringWidth(s) : -dim.width / 2));
            g.drawString(s, x + x1, y + y1);
            if (this.fond == 0.0f) {
                Util.drawStringOutline(g, s, x + x1, y + y1, null, Color.black);
            } else {
                g.drawString(s, x + x1, y + y1);
            }
            y1 += m.getHeight();
        }
    }

    private void drawHampe(Graphics g, int x, int y) {
        if (this.tag == 7 || this.dist <= 3.0) {
            return;
        }
        Point ancrage = this.getXYAncrage();
        Point poignee = this.getXYPoignee();
        if (this.isArrow()) {
            Util.drawFleche(g, x + poignee.x, y + poignee.y, x + ancrage.x, y + ancrage.y, this.tag == 6 ? 10 : 6, null);
        } else {
            g.drawLine(x + poignee.x, y + poignee.y, x + ancrage.x, y + ancrage.y);
        }
        if (this.hasLabel() || this.editing) {
            int att = this.angle > 1.5707963267948966 && this.angle < 4.71238898038469 ? -(this.accroche - 3) : this.accroche - 3;
            g.drawLine(x + poignee.x, y + poignee.y, x + poignee.x + att, y + poignee.y);
        }
    }

    private void drawCaret(Graphics g, int x, int y) {
        boolean blink;
        boolean bl = blink = System.currentTimeMillis() / 500L % 2L == 0L;
        if (!blink) {
            return;
        }
        Color c = g.getColor();
        Point p = this.getXYLastChar();
        int h = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont()).getHeight();
        g.setColor(Color.black);
        g.drawLine(x += p.x, (y += p.y) + 2, x, y - h + 2);
        g.setColor(Color.white);
        g.drawLine(x + 1, y + 2, x + 1, y - h + 2);
        g.setColor(c);
    }

    private void drawMiniFleche(Graphics g, int x, int y) {
        int tmp = this.L;
        this.L = 10;
        Point p = this.getXYAncrage();
        this.L = tmp;
        Util.drawFleche(g, x + p.x, y + p.y, x, y, 4, null);
    }

    private void drawTag(Graphics g, int x, int y) {
        if (this.tag == 7) {
            return;
        }
        if (this.dist < 3.0 && this.hasLabel() && !this.isEditing()) {
            return;
        }
        switch (this.tag) {
            case 0: 
            case 1: {
                g.drawLine(x - this.L, y, x - 2, y);
                g.drawLine(x + 2, y, x + this.L, y);
                g.drawLine(x, y - this.L, x, y - 2);
                g.drawLine(x, y + 2, x, y + this.L);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (this.L < 3) {
                    Util.drawCircle5(g, x, y);
                    break;
                }
                if (this.L <= 4) {
                    Util.drawCircle8(g, x, y);
                    break;
                }
                g.drawOval(x - this.L, y - this.L, this.L * 2, this.L * 2);
            }
        }
    }

    @Override
    protected boolean draw(Graphics g, ViewSimple v, int dx, int dy) {
        if (!this.isVisible()) {
            return false;
        }
        Point p = this.getViewCoord(v, 50, 50);
        if (p == null) {
            return false;
        }
        p.x += dx;
        p.y += dy;
        g.setFont(this.getFont());
        g.setColor(this.getColor());
        boolean isTooSmallForLabel = this.isTooSmallForLabel(v);
        this.drawTag(g, p.x, p.y);
        if (isTooSmallForLabel) {
            if (this.isArrow()) {
                this.drawMiniFleche(g, p.x, p.y);
            }
            return true;
        }
        if (this.hasLabel() || this.isArrow()) {
            this.drawHampe(g, p.x, p.y);
            if (this.hasLabel() && !isTooSmallForLabel) {
                this.drawLabel(g, p.x, p.y);
            }
        }
        if (this.editing) {
            this.drawHampe(g, p.x, p.y);
            this.drawCaret(g, p.x, p.y);
        }
        if (this.isSelected()) {
            if (this.plan != null && this.plan.type == 10) {
                return true;
            }
            this.drawSelect(g, v);
        }
        return true;
    }
}

